package io.dyte.core.models

data class DyteAudioDevice(
  val id: String,
  val type: AudioDeviceType,
){
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["id"] = id
    map["type"] = type.toMap()
    return map
  }
}

enum class AudioDeviceType(val deviceType: String, val displayName: String) {
  WIRED("WIRED_HEADSET", "Headset"),
  SPEAKER("SPEAKER_PHONE", "Speaker"),
  BLUETOOTH("BLUETOOTH", "Bluetooth"),
  EAR_PIECE("EARPIECE", "Earpiece"),
  UNKNOWN("NONE", "Unknown");
  fun toMap() : Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["deviceType"] = deviceType
    map["displayName"] = displayName
    return map
  }
}
