package io.dyte.core.listeners

import io.dyte.core.models.DyteChatMessage
import io.dyte.core.models.DytePlugin
import io.dyte.core.models.DytePollMessage
import kotlinx.serialization.json.JsonObject

/**
 * Dyte meeting room events listener
 *
 * You can subscribe to all room events by implementing this interface.
 * To subscribe pass implementation to [io.dyte.core.DyteMobileClient.addMeetingRoomEventsListener]
 */
interface DytePluginEventsListener {
    fun onMeetingInitFailed(exception: Exception) {}

    /**
     * On meeting room join started
     * Triggered once the sdk starts making connection to the roomname you passed.
     * Ideally one should show loader on UI once this event is triggered.
     */
    fun onPluginActivated(plugin: DytePlugin) {}


    /**
     * On meeting room left
     *
     * Triggered once this user is left successfully from the meeting
     *
     */
    fun onPluginDeactivated(plugin: DytePlugin) {}
    fun onPluginMessage(message: JsonObject) {}

}