package io.dyte.core.listeners

import io.dyte.core.models.DyteMeetingParticipant
import io.dyte.core.models.DyteRoomParticipants

// TODO : add active participant changed.
// TODO : add screenshare update ? currently added in MeetingRoomEvents
/**
 * Dyte participant events listener
 *
 * You can subscribe to all participant events by implementing this interface.
 * To subscribe pass implementation to [io.dyte.core.DyteMobileClient.addParticipantEventsListener]
 *
 * @constructor Create empty Dyte participant events listener
 */
interface DyteParticipantEventsListener {
  /**
   * On participant join
   *
   * Triggered when a new user joins this room
   *
   * @param participant
   */
  fun onParticipantJoin(participant: DyteMeetingParticipant) {}

  /**
   * On participant leave
   *
   * Triggered when a user leaves/kicked from this room
   *
   * @param participant
   */
  fun onParticipantLeave(participant: DyteMeetingParticipant) {}

  /**
   * On participant updated
   *
   * Triggered when there is an update on a given participant.
   * Update can either be audio toggle, video toggle or screen share toggle.
   *
   * @param participant
   */
  fun onParticipantUpdated(participant: DyteMeetingParticipant) {}

  /**
   * On screen share started and ended
   *
   * Triggered when someone starts or end screen share in this room
   *
   * @param participant
   */
  fun onScreenSharesUpdated() {}

  /**
   * Audio update
   *
   * when a give participant toggles audio from their device.
   * Also triggered when host toggles audio for the participant
   *
   * @param audioEnabled : true if audio is enabled, false otherwise
   * @param participant : participant for whom there was audio change
   */
  fun audioUpdate(audioEnabled: Boolean, participant: DyteMeetingParticipant) {}

  /**
   * Video update
   *
   * when a give participant toggles video from their device.
   * Also triggered when host toggles video for the participant
   *
   * @param videoEnabled : true if video is enabled, false otherwise
   * @param participant : participant for whom there was video change
   */
  fun videoUpdate(videoEnabled: Boolean, participant: DyteMeetingParticipant) {}

  /**
   * On participants updated
   *
   * Triggered when there are updates in the meeting room participants
   * 1. new user joins
   * 2. new user in waiting room
   * 3. new user is pinned/unpinned
   * 4. User leaves meeting
   * 5. Page updates
   *
   * @param participants: contains all participants
   * @param enabledPaginator: true if there are more than one page in this meeting
   */
  fun onParticipantsUpdated(participants: DyteRoomParticipants, isNextPagePossible: Boolean, isPreviousPagePossible: Boolean) {}

  fun onActiveSpeakerChanged(participant: DyteMeetingParticipant) {}
  fun onNoActiveSpeaker() {}

  fun onParticipantPinned(participant: DyteMeetingParticipant) {}
  fun onParticipantUnpinned() {}

  // called whenever there is any change in participant
  fun onUpdate(participants: DyteRoomParticipants) {}
}