package io.dyte.core.controllers

import io.dyte.core.models.DyteMeetingInfo
import io.dyte.core.models.DyteMeta

/**
 * Meta controller
 *
 * Contains meta details about the meeting,
 * example: [DyteMeetingInfo]
 *
 * @constructor Create empty Meta controller
 */
internal class MetaController(
  private val dyteMeetingInfo: DyteMeetingInfo,
  controllerContainer: IControllerContainer
) : IMetaController, BaseController(controllerContainer) {
  private lateinit var meetingUserPeerId: String
  private lateinit var meetingStartedTimestamp: String
  private lateinit var meetingTitle: String
  private var isHost: Boolean = false
  private lateinit var roomType: String

  override fun init() {
    meetingUserPeerId =  controllerContainer.platformUtilsProvider.getPlatformUtils().getUuid()
  }

  override fun getMeetingInfo(): DyteMeetingInfo {
    return dyteMeetingInfo
  }

  override fun getDisplayName(): String {
    return dyteMeetingInfo.displayName
  }

  override fun getRoomName(): String {
    return dyteMeetingInfo.roomName
  }

  override fun getAuthToken(): String {
    return dyteMeetingInfo.authToken
  }

  override fun getBaseUrl(): String {
    return dyteMeetingInfo.baseUrl
  }

  override fun getPeerId(): String {
    return meetingUserPeerId
  }

  override fun getOrgId(): String {
    return dyteMeetingInfo.orgId
  }

  override fun getMeetingTitle(): String {
    return meetingTitle
  }

  override fun getMeetingStatedTimestamp(): String {
    return meetingStartedTimestamp
  }

  override fun getRoomType(): String {
    return roomType
  }

  override fun setMeetingTitle(title: String) {
    this.meetingTitle = title
  }

  override fun setMeetingStartedTimestamp(timestamp: String) {
    this.meetingStartedTimestamp = timestamp
  }

  override fun setRoomType(roomType: String) {
    this.roomType = roomType
  }

  override fun setIsHost(isHost: Boolean) {
    this.isHost = isHost
  }

  override fun getIsHost(): Boolean {
    return isHost
  }
}

interface IMetaController {
  fun getMeetingInfo(): DyteMeetingInfo

  fun getPeerId(): String
  fun getBaseUrl(): String
  fun getDisplayName(): String
  fun getRoomName(): String
  fun getAuthToken(): String
  fun getOrgId(): String

  fun setMeetingTitle(title: String)
  fun setMeetingStartedTimestamp(timestamp: String)
  fun setRoomType(roomType: String)
  fun setIsHost(isHost:  Boolean)

  fun getMeetingTitle(): String
  fun getMeetingStatedTimestamp(): String
  fun getRoomType(): String
  fun getIsHost(): Boolean
}

