package io.dyte.core.controllers

import io.dyte.core.models.DyteMeetingParticipant
import io.dyte.core.socket.events.OutboundMeetingEventType.KICK_ALL
import io.dyte.core.socket.events.OutboundMeetingEventType.KICK_PEER
import io.dyte.core.socket.events.OutboundMeetingEventType.MUTE_ALL_AUDIO
import io.dyte.core.socket.events.OutboundMeetingEventType.MUTE_ALL_VIDEO
import io.dyte.core.socket.events.OutboundMeetingEventType.MUTE_PEER_AUDIO
import io.dyte.core.socket.events.OutboundMeetingEventType.MUTE_PEER_VIDEO
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive

internal class HostController(controllerContainer: IControllerContainer) : IHostController,
  BaseController(controllerContainer) {
  override fun init() {
  }

  override fun kick(id: String) {
    if (controllerContainer.presetController.permission.permissions?.kickParticipant == false) {
      throw UnsupportedOperationException("not allowed to kick")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(id)
      controllerContainer.socketController.sendMessageSync(KICK_PEER, JsonObject(content))
    }
  }

  override fun kickAll() {
    if (controllerContainer.presetController.permission.permissions?.kickParticipant == false) {
      throw UnsupportedOperationException("not allowed to kick all")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      controllerContainer.socketController.sendMessageSync(KICK_ALL, null)
    }
  }

  override fun muteAllAudio(allowUnmute: Boolean) {
    if (controllerContainer.presetController.permission.permissions?.canDisableParticipantAudio == false) {
      throw UnsupportedOperationException("not allowed to disable audio")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      val content = HashMap<String, JsonElement>()
      content["allowUnMute"] = JsonPrimitive(allowUnmute)
      controllerContainer.socketController.sendMessageSync(MUTE_ALL_AUDIO, JsonObject(content))
    }
  }

  override fun muteAllVideo() {
    if (controllerContainer.presetController.permission.permissions?.canDisableParticipantVideo == false) {
      throw UnsupportedOperationException("not allowed to disable video")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      controllerContainer.socketController.sendMessageSync(MUTE_ALL_VIDEO, null)
    }
  }

  override fun muteAudio(dyteMeetingParticipant: DyteMeetingParticipant) {
    if (controllerContainer.presetController.permission.permissions?.canDisableParticipantAudio == false) {
      throw UnsupportedOperationException("not allowed to disable audio")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(dyteMeetingParticipant.id)
      controllerContainer.socketController.sendMessageSync(MUTE_PEER_AUDIO, JsonObject(content))
    }
  }

  override fun muteVideo(dyteMeetingParticipant: DyteMeetingParticipant) {
    if (controllerContainer.presetController.permission.permissions?.canDisableParticipantVideo == false) {
      throw UnsupportedOperationException("not allowed to disable video")
    }
    controllerContainer.platformUtilsProvider.getPlatformUtils().runOnIoThread {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(dyteMeetingParticipant.id)
      controllerContainer.socketController.sendMessageSync(MUTE_PEER_VIDEO, JsonObject(content))
    }
  }
}

interface IHostController {
  fun muteAllAudio(allowUnmute: Boolean)
  fun muteAudio(dyteMeetingParticipant: DyteMeetingParticipant)

  fun muteAllVideo()
  fun muteVideo(dyteMeetingParticipant: DyteMeetingParticipant)

  fun kickAll()
  fun kick(id: String)
}
