package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetRequestModel(
  @JsonNames("authToken")
  val authToken: String? = null,

  @JsonNames("clientType")
  val clientType: String? = null,

  @JsonNames("roomName")
  val roomName: String? = null,

  @JsonNames("version")
  val version: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetDataWrapper(
  @JsonNames("success")
  val success: Boolean? = null,

  @JsonNames("message")
  val message: String? = null,

  @JsonNames("data")
  val data: UserPresetData? = null,
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetData(
  @JsonNames("preset")
  val preset: UserPresetModel? = null,
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetModel(
  @JsonNames("permissions")
  val permissions: UserPresetPermissionsModel? = null,

  @JsonNames("theme")
  val theme: UserPresetThemeModel? = null,

  @JsonNames("version")
  val version: String? = null,

  @JsonNames("preset_name")
  val presetName: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetPermissionsModel(
  @JsonNames("view_type")
  val viewType: String? = null,

  @JsonNames("accept_waiting_requests")
  val acceptWaitingRequests: Boolean? = null,

  @JsonNames("request_produce")
  val requestProduce: Boolean? = null,

  @JsonNames("can_allow_participant_screensharing")
  val canAllowParticipantScreensharing: Boolean? = null,

  @JsonNames("can_allow_participant_audio")
  val canDisableParticipantAudio: Boolean? = null,

  @JsonNames("can_allow_participant_video")
  val canDisableParticipantVideo: Boolean? = null,

  @JsonNames("request_kick_participant")
  val requestKickParticipant: Boolean? = null,

  @JsonNames("kick_participant")
  val kickParticipant: Boolean? = null,

  @JsonNames("pin_participant")
  val pinParticipant: Boolean? = null,

  @JsonNames("can_record")
  val canRecord: Boolean? = null,

  @JsonNames("waiting_room_type")
  val waitingRoomType: WaitingRoomType,

  @JsonNames("plugins")
  val plugins: UserPresetPluginPermissions? = null,

  @JsonNames("polls")
  val polls: UserPresetPollsPermissions? = null,

  @JsonNames("produce")
  val produce: UserPresetProducePermissions? = null,

  @JsonNames("chat")
  val chat: UserPresetChatPermissionProps? = null,

  @JsonNames("reactions")
  val reactions: Boolean? = null,

  @JsonNames("hidden_participant")
  val hiddenParticipant: Boolean? = null,

  @JsonNames("show_participant_list")
  val showParticipantList: Boolean? = null,

  @JsonNames("can_change_participant_role")
  val canChangeParticipantRole: Boolean? = null,

  @JsonNames("can_change_theme")
  val canChangeTheme: Boolean? = null,

  @JsonNames("can_present")
  val canPresent: Boolean? = null,

  @JsonNames("accept_present_requests")
  val acceptPresentRequests: Boolean? = null,

  @JsonNames("can_edit_display_name")
  val canEditDisplayName: Boolean? = null,

  @JsonNames("is_recorder")
  val isRecorder: Boolean? = null,
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetPluginPermissions(
  @JsonNames("can_close")
  val canClose: Boolean? = null,

  @JsonNames("can_start")
  val canStart: Boolean? = null,

  @JsonNames("can_edit_acl")
  val canEditAcl: Boolean? = null,

  @JsonNames("config")
  val config: UserPresetPluginConfig? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
class UserPresetPluginConfig

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetPollsPermissions(
  @JsonNames("can_create")
  val canCreate: Boolean? = null,

  @JsonNames("can_vote")
  val canVote: Boolean? = null,

  @JsonNames("can_view")
  val canView: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetChatPermissionProps(
  @JsonNames("public")
  val chatPublicProps: ChatPublicPermissions? = null,

  @JsonNames("private")
  val chatPrivateProps: ChatPrivatePermissions? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ChatPrivatePermissions(
  @JsonNames("can_send")
  val canSend: Boolean? = null,

  @JsonNames("can_receive")
  val canReceive: Boolean? = null,

  @JsonNames("text")
  val text: Boolean? = null,

  @JsonNames("files")
  val files: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ChatPublicPermissions(
  @JsonNames("can_send")
  val canSend: Boolean? = null,

  @JsonNames("text")
  val text: Boolean? = null,

  @JsonNames("files")
  val files: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetProducePermissions(
  @JsonNames("video")
  val video: UserPresetVideoPermissions? = null,

  @JsonNames("audio")
  val audio: Boolean? = null,

  @JsonNames("screenshare")
  val screenshare: UserPresetScreenSharePermissions? = null
)



@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetScreenSharePermissions(
  @JsonNames("allow")
  val allow: Boolean? = null,

  @JsonNames("quality")
  val quality: String? = null,

  @JsonNames("frame_rate")
  val frameRate: Int? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetVideoPermissions(
  @JsonNames("allow")
  val allow: Boolean? = null,

  @JsonNames("quality")
  val quality: String? = null,

  @JsonNames("frame_rate")
  val frameRate: Int? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetThemeModel(
  // @JsonNames("setup_screen")
  // var setupScreen: UserPresetSetupScreenTheme? = null,

  // @JsonNames("alone_here")
  // var aloneHere: UserPresetAloneHereTheme? = null,

  // @JsonNames("waiting_room")
  // var waitingRoom: UserPresetWaitingRoomTheme? = null,

  // @JsonNames("control_bar")
  // var controlBar: UserPresetControlBarTheme? = null,

  // @JsonNames("header")
  // var header: UserPresetHeaderTheme? = null,

  // @JsonNames("pip_mode")
  // var pipMode: Boolean? = null,

  // @JsonNames("auto_tune")
  // var autoTune: Boolean? = null,

  @JsonNames("grid")
  var grid: UserPresetGridTheme? = null,

  // @JsonNames("colors")
  // var colors: UserPresetColorsTheme? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetAloneHereTheme(
  @JsonNames("is_enabled")
  var isEnabled: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetColorsTheme(
  @JsonNames("primary")
  var primary: String? = null,

  @JsonNames("secondary")
  var secondary: String? = null,

  @JsonNames("text")
  var text: String? = null,

  @JsonNames("background")
  var background: String? = null,

  @JsonNames("textPrimary")
  var textPrimary: String? = null,

  @JsonNames("videoBackground")
  var videoBackground: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetControlBarTheme(
  @JsonNames("is_enabled")
  var isEnabled: Boolean? = null,

  @JsonNames("elements")
  var elements: UserPresetControlBarThemeElements? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetControlBarThemeElements(
  @JsonNames("plugins")
  var plugins: Boolean? = null,

  @JsonNames("screenshare")
  var screenshare: Boolean? = null,

  @JsonNames("invite")
  var invite: Boolean? = null,

  @JsonNames("participants")
  var participants: Boolean? = null,

  @JsonNames("chat")
  var chat: Boolean? = null,

  @JsonNames("reactions")
  var reactions: Boolean? = null,

  @JsonNames("polls")
  var polls: Boolean? = null,

  @JsonNames("fullscreen")
  var fullscreen: Boolean? = null,

  @JsonNames("layout")
  var layout: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetHeaderThemeElements(
  @JsonNames("logo")
  var logo: String? = null,

  @JsonNames("timer")
  var timer: Boolean? = null,

  @JsonNames("title")
  var title: Boolean? = null,

  @JsonNames("participant_count")
  var participantCount: Boolean? = null,

  @JsonNames("change_layout")
  var changeLayout: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetGridTheme(
  @JsonNames("multi")
  var multi: UserPresetMultiTheme? = null,

  @JsonNames("single")
  var single: UserPresetSingleTheme? = null,

  @JsonNames("defaultView")
  var defaultView: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetHeaderTheme(
  @JsonNames("is_enabled")
  var isEnabled: Boolean? = null,

  @JsonNames("elements")
  var elements: UserPresetHeaderThemeElements? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetMultiTheme(
  @JsonNames("maxVideoCount")
  var maxVideoCount: Int? = null,

  @JsonNames("videoFit")
  var videoFit: String? = null
)

// ignore
@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetSetupScreenTheme(
  @JsonNames("is_enabled")
  var isEnabled: Boolean? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetSingleTheme(
  @JsonNames("maxVideoCount")
  var maxVideoCount: Int? = null,

  @JsonNames("videoFit")
  var videoFit: String? = null
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class UserPresetWaitingRoomTheme(
  @JsonNames("is_enabled")
  var isEnabled: Boolean? = null,

  @JsonNames("enable_preview")
  var enablePreview: Boolean? = null
)

@Serializable
enum class WaitingRoomType {
  @SerialName("SKIP") SKIP,
  @SerialName("ON_ACCEPT") ON_ACCEPT,
  @SerialName("SKIP_ON_ACCEPT") SKIP_ON_ACCEPT,
  @SerialName("SKIP_ON_PRIVILEGED_USER_ENTRY") SKIP_ON_PRIVILEGED_USER_ENTRY;
}
