package io.dyte.core.models

import io.dyte.core.models.DyteMessageType.FILE
import io.dyte.core.models.DyteMessageType.IMAGE
import io.dyte.core.models.DyteMessageType.TEXT

open class DyteChatMessage(
  val userId: String,
  val displayName: String,
  val read: Boolean,
  val pluginId: String?,
  val type: DyteMessageType,
  val time: String
)

class DyteTextMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val message: String,
  time: String
) : DyteChatMessage(userId, displayName, read, pluginId, TEXT, time)

class DyteImageMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val link: String,
  val fileUri: String?,
  val fileName: String?,
  time: String
) : DyteChatMessage(userId, displayName, read, pluginId, IMAGE, time)

class DyteFileMessage(
  userId: String,
  displayName: String,
  read: Boolean,
  pluginId: String?,
  val name: String,
  val fileUri: String?,
  time: String
) : DyteChatMessage(userId, displayName, read, pluginId, FILE, time)

fun encodeDyteChatMessage(message: DyteChatMessage): Map<String, Any?> {
  val chatMessageMap = HashMap<String, Any?>()
  chatMessageMap["displayName"] = message.displayName
  chatMessageMap["type"] = message.type.name
  chatMessageMap["read"] = message.read
  chatMessageMap["userId"] = message.userId
  chatMessageMap["pluginId"] = message.pluginId
  when (message) {
    is DyteFileMessage -> {
      chatMessageMap["fileUri"] = message.fileUri
      chatMessageMap["name"] = message.name
    }
    is DyteTextMessage -> {
      chatMessageMap["message"] = message.message
    }
    is DyteImageMessage -> {
      chatMessageMap["fileName"] = message.fileName
      chatMessageMap["fileUri"] = message.fileUri
      chatMessageMap["link"] = message.link
    }
  }
  return chatMessageMap
}

enum class DyteMessageType {
  TEXT,
  IMAGE,
  FILE;
}

