package io.dyte.core.listeners

import io.dyte.core.models.DyteMeetingParticipant
import io.dyte.core.models.WaitListStatus

/**
 * Dyte self events listener
 *
 * You can subscribe to all self events by implementing this interface.
 * To subscribe pass implementation to [io.dyte.core.DyteMobileClient.addSelfEventsListener]
 *
 * @constructor Create empty Dyte self events listener
 */
// TODO : device change callback.
interface DyteSelfEventsListener {
  /**
   * On meeting room join started
   * Triggered once the sdk starts making connection to the roomname you passed.
   * Ideally one should show loader on UI once this event is triggered.
   */
  fun onMeetingRoomJoinStarted() {}

  /**
   * On meeting room join failed
   *
   * Triggered when some error happended while executing [io.dyte.core.DyteMobileClient.joinRoom]
   * or [io.dyte.core.DyteMobileClient.init]
   *
   * @param exception - actual exception. This can be either http exception or any android exception
   */
  fun onMeetingRoomJoinFailed(exception: Exception) {}

  fun onMeetingRoomJoined() {}

  fun onMeetingRoomLeaveStarted() {}
  /**
   * On meeting room left
   *
   * Triggered once this user is left successfully from the meeting
   *
   */
  fun onMeetingRoomLeft() {}

  /**
   * When connection to meeting room is lost due to network conditions
   */
  fun onMeetingRoomDisconnected() {}

  fun onMeetingRoomJoinedWithoutCameraPermission() {}
  fun onMeetingRoomJoinedWithoutMicPermission() {}

  /**
   * Audio update
   *
   * when this participant mutes/un-mutes their audio
   * Also triggered when host toggles audio for this participant
   *
   * @param audioEnabled : true if audio is enabled, false otherwise
   */
  fun onAudioUpdate(audioEnabled: Boolean) {}

  /**
   * Video update
   *
   * when this participant mutes/un-mutes their video.
   * Also triggered when host toggles video for this participant
   *
   * @param videoEnabled : true if video is enabled, false otherwisee
   */
  fun onVideoUpdate(videoEnabled: Boolean) {}

  fun onAudioDevicesUpdated() {}

  fun onProximityChanged(isNear: Boolean) {}

  fun onWaitListStatusUpdate(waitListStatus: WaitListStatus) {}

  // called whenever audio/video is updated
  fun onUpdate(participant: DyteMeetingParticipant) {}

  /**
   * triggered when local user receives request to present, it can happen in following scenario
   *
   * 1. when user requests to join stage and then host accepts it, user receives this callback
   * 2. hosts adds local user on stage
   */
  fun onWebinarPresentRequestReceived() {}

  fun onStoppedPresenting() {}
}