package io.dyte.mobilecorebridge

import platform.Foundation.NSURL
import platform.UIKit.UIApplication

actual class DyteUtils actual constructor() {
  actual fun launchUrl(context: Any?, url: String): Boolean {
    val formattedUrl =
      if (!url.startsWith("http://") && !url.startsWith("https://")) {
        "http://$url"
      } else {
        url
      }

    val nsUrl = NSURL(string = formattedUrl)
    return UIApplication.sharedApplication.canOpenURL(nsUrl) &&
      UIApplication.sharedApplication.openURL(nsUrl)
  }

  actual fun enableWakelock() {
    UIApplication.sharedApplication.idleTimerDisabled = true
  }

  actual fun disableWakelock() {
    UIApplication.sharedApplication.idleTimerDisabled = false
  }
}
