package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DytePlugin
import io.dyte.core.listeners.DytePluginEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class PluginEventsListener(private val sink: DyteSink) : DytePluginEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onPluginActivated(plugin: DytePlugin) {
    super.onPluginActivated(plugin)
    val pluginMap =
      hashMapOf<String, Any?>(
        "id" to plugin.id,
        "name" to plugin.name,
        "description" to plugin.description,
        "picture" to plugin.picture,
        "private" to plugin.isPrivate,
        "staggered" to plugin.staggered,
        "baseURL" to plugin.baseURL,
      )

    callDetailsBuilder.flush().addMethodName("onPluginActivated").addArguments(pluginMap)
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginDeactivated(plugin: DytePlugin) {
    super.onPluginDeactivated(plugin)

    val pluginMap =
      hashMapOf<String, Any?>(
        "id" to plugin.id,
        "name" to plugin.name,
        "description" to plugin.description,
        "picture" to plugin.picture,
        "private" to plugin.isPrivate,
        "staggered" to plugin.staggered,
        "baseURL" to plugin.baseURL,
      )
    callDetailsBuilder.flush().addMethodName("onPluginDeactivated").addArguments(pluginMap)
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginFileRequest(plugin: DytePlugin) {

    callDetailsBuilder
      .flush()
      .addMethodName("onPluginFileRequest")
      .addArguments(hashMapOf("plugin" to decodePlugin(plugin)))
    sink.success(callDetailsBuilder.build())
  }

  private fun decodePlugin(plugin: DytePlugin): Map<String, Any?> {
    return mapOf(
      "id" to plugin.id,
      "name" to plugin.name,
      "description" to plugin.description,
      "picture" to plugin.picture,
      "private" to plugin.isPrivate,
      "staggered" to plugin.staggered,
      "baseURL" to plugin.baseURL,
    )
  }

  override fun onPluginMessage(plugin: DytePlugin, eventName: String, data: Any?) {
    super.onPluginMessage(plugin, eventName, data)

    callDetailsBuilder
      .flush()
      .addMethodName("onPluginMessage")
      .addArguments(
        hashMapOf(
          "plugin" to decodePlugin(plugin),
          "eventName" to eventName,
          "data" to data.toString(),
        )
      )
    sink.success(callDetailsBuilder.build())
  }
}
