package io.dyte.mobilecorebridge

import platform.Foundation.NSURL
import platform.UIKit.UIApplication

actual class DyteUtils {
  actual fun launchUrl(url: String): Boolean {
    val formattedUrl =
      if (!url.startsWith("http://") && !url.startsWith("https://")) {
        "http://$url"
      } else {
        url
      }

    val nsUrl = NSURL(string = formattedUrl)
    return UIApplication.sharedApplication.canOpenURL(nsUrl) &&
      UIApplication.sharedApplication.openURL(nsUrl)
  }
}
