package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.listeners.DyteParticipantEventsListener
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.models.DyteRoomParticipants
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class ParticipantEventListener(private val sink: DyteSink) : DyteParticipantEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onActiveParticipantsChanged(active: List<DyteJoinedMeetingParticipant>) {
    super.onActiveParticipantsChanged(active)
    callDetailsBuilder
      .flush()
      .addMethodName("onActiveParticipantsChanged")
      .addArguments(hashMapOf("active" to active.map { it.toMap() }))
    sink.success(callDetailsBuilder.build())
  }

  override fun onActiveSpeakerChanged(participant: DyteJoinedMeetingParticipant) {
    super.onActiveSpeakerChanged(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onActiveSpeakerChanged")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onAudioUpdate(audioEnabled: Boolean, participant: DyteMeetingParticipant) {
    super.onAudioUpdate(audioEnabled, participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onAudioUpdate")
      .addArguments(hashMapOf("audioEnabled" to audioEnabled, "participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onNoActiveSpeaker() {
    super.onNoActiveSpeaker()
    callDetailsBuilder.flush().addMethodName("onNoActiveSpeaker")
    sink.success(callDetailsBuilder.build())
  }

  override fun onParticipantJoin(participant: DyteJoinedMeetingParticipant) {
    super.onParticipantJoin(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onParticipantJoin")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onParticipantLeave(participant: DyteJoinedMeetingParticipant) {
    super.onParticipantLeave(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onParticipantLeave")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onParticipantPinned(participant: DyteJoinedMeetingParticipant) {
    super.onParticipantPinned(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onParticipantPinned")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onParticipantUnpinned(participant: DyteJoinedMeetingParticipant) {
    super.onParticipantUnpinned(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onParticipantUnpinned")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareEnded(participant: DyteJoinedMeetingParticipant) {
    super.onScreenShareEnded(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onScreenShareEnded")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareStarted(participant: DyteJoinedMeetingParticipant) {
    super.onScreenShareStarted(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onScreenShareStarted")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenSharesUpdated() {
    super.onScreenSharesUpdated()
    callDetailsBuilder.flush().addMethodName("onScreenSharesUpdated")
    sink.success(callDetailsBuilder.build())
  }

  override fun onUpdate(participants: DyteRoomParticipants) {
    super.onUpdate(participants)
    callDetailsBuilder
      .flush()
      .addMethodName("onUpdate")
      .addArguments(hashMapOf("participants" to participants.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onVideoUpdate(videoEnabled: Boolean, participant: DyteMeetingParticipant) {
    super.onVideoUpdate(videoEnabled, participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onVideoUpdate")
      .addArguments(hashMapOf("videoEnabled" to videoEnabled, "participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }
}
