package io.dyte.mobilecorebridge.listeners

import io.dyte.core.listeners.DyteMeetingRoomEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class RoomEventListener(private val dyteRoomSink: DyteSink) : DyteMeetingRoomEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onMeetingInitStarted() {
    super.onMeetingInitStarted()
    callDetailsBuilder.flush().addMethodName("onMeetingInitStarted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingInitCompleted() {
    super.onMeetingInitCompleted()
    callDetailsBuilder.flush().addMethodName("onMeetingInitCompleted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomDisconnected() {
    super.onMeetingRoomDisconnected()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomDisconnected")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomJoinCompleted() {
    super.onMeetingRoomJoinCompleted()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomJoinCompleted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomJoinFailed(exception: Exception) {
    super.onMeetingRoomJoinFailed(exception)
    callDetailsBuilder
      .flush()
      .addMethodName("onMeetingRoomJoinFailed")
      .addArguments(hashMapOf("exception" to exception.message))
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomJoinStarted() {
    super.onMeetingRoomJoinStarted()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomJoinStarted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomLeaveCompleted() {
    super.onMeetingRoomLeaveCompleted()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomLeaveCompleted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomLeaveStarted() {
    super.onMeetingRoomLeaveStarted()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomLeaveStarted")
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingInitFailed(exception: Exception) {
    super.onMeetingInitFailed(exception)
    callDetailsBuilder
      .flush()
      .addMethodName("onMeetingInitFailed")
      .addArguments(hashMapOf("exception" to exception.message))
    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onReconnectingToMeetingRoom() {
    super.onReconnectingToMeetingRoom()

    callDetailsBuilder.flush().addMethodName("onReconnectingToMeetingRoom")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onReconnectedToMeetingRoom() {
    super.onReconnectedToMeetingRoom()

    callDetailsBuilder.flush().addMethodName("onReconnectedToMeetingRoom")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomReconnectionFailed() {
    super.onMeetingRoomReconnectionFailed()

    callDetailsBuilder.flush().addMethodName("onMeetingRoomReconnectionFailed")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onConnectedToMeetingRoom() {
    super.onConnectedToMeetingRoom()

    callDetailsBuilder.flush().addMethodName("onConnectedToMeetingRoom")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onConnectingToMeetingRoom() {
    super.onConnectingToMeetingRoom()

    callDetailsBuilder.flush().addMethodName("onConnectingToMeetingRoom")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onDisconnectedFromMeetingRoom() {
    super.onDisconnectedFromMeetingRoom()

    callDetailsBuilder.flush().addMethodName("onDisconnectedFromMeetingRoom")

    dyteRoomSink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomConnectionFailed() {
    super.onMeetingRoomConnectionFailed()

    callDetailsBuilder.flush().addMethodName("onMeetingRoomConnectionFailed")

    dyteRoomSink.success(callDetailsBuilder.build())
  }
}
