package io.dyte.mobilecorebridge.listeners

import io.dyte.core.controllers.DyteStageStatus
import io.dyte.core.listeners.DyteStageEventListener
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class StageEventsListener(private var sink: DyteSink) : DyteStageEventListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onAddedToStage() {
    super.onAddedToStage()

    callDetailsBuilder.flush().addMethodName("onAddedToStage")

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestClosed(participant: DyteJoinedMeetingParticipant) {
    super.onPresentRequestClosed(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onPresentRequestClosed")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestReceived() {
    super.onPresentRequestReceived()

    callDetailsBuilder.flush().addMethodName("onPresentRequestReceived")

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestAccepted(participant: DyteJoinedMeetingParticipant) {

    callDetailsBuilder
      .flush()
      .addMethodName("onPresentRequestAccepted")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestAdded(participant: DyteJoinedMeetingParticipant) {
    super.onPresentRequestAdded(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onPresentRequestAdded")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestRejected(participant: DyteJoinedMeetingParticipant) {
    super.onPresentRequestRejected(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onPresentRequestRejected")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onPresentRequestWithdrawn(participant: DyteJoinedMeetingParticipant) {
    super.onPresentRequestWithdrawn(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onPresentRequestWithdrawn")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onStageRequestsUpdated(accessRequests: List<DyteJoinedMeetingParticipant>) {
    super.onStageRequestsUpdated(accessRequests)

    callDetailsBuilder
      .flush()
      .addMethodName("onStageRequestsUpdated")
      .addArguments(hashMapOf("accessRequests" to accessRequests.map { it.toMap() }))

    sink.success(callDetailsBuilder.build())
  }

  override fun onRemovedFromStage() {
    super.onRemovedFromStage()

    callDetailsBuilder.flush().addMethodName("onRemovedFromStage")

    sink.success(callDetailsBuilder.build())
  }

  override fun onParticipantRemovedFromStage(participant: DyteJoinedMeetingParticipant) {
    super.onParticipantRemovedFromStage(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onParticipantRemovedFromStage")
      .addArguments(hashMapOf("participant" to participant.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onStageStatusUpdated(stageStatus: DyteStageStatus) {
    super.onStageStatusUpdated(stageStatus)

    callDetailsBuilder
      .flush()
      .addMethodName("onStageStatusUpdated")
      .addArguments(hashMapOf("stageStatus" to stageStatus.toString()))

    sink.success(callDetailsBuilder.build())
  }
}
