package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DytePlugin
import io.dyte.core.listeners.DytePluginEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink
import kotlinx.serialization.json.JsonObject

class PluginEventsListener(private val sink: DyteSink) : DytePluginEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onPluginActivated(plugin: DytePlugin) {
    super.onPluginActivated(plugin)
    val pluginMap =
      hashMapOf<String, Any?>(
        "id" to plugin.id,
        "name" to plugin.name,
        "description" to plugin.description,
        "picture" to plugin.picture,
        "private" to plugin.isPrivate,
        "staggered" to plugin.staggered,
        "baseURL" to plugin.baseURL,
      )

    callDetailsBuilder.flush().addMethodName("onPluginActivated").addArguments(pluginMap)
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginDeactivated(plugin: DytePlugin) {
    super.onPluginDeactivated(plugin)

    val pluginMap =
      hashMapOf<String, Any?>(
        "id" to plugin.id,
        "name" to plugin.name,
        "description" to plugin.description,
        "picture" to plugin.picture,
        "private" to plugin.isPrivate,
        "staggered" to plugin.staggered,
        "baseURL" to plugin.baseURL,
      )
    callDetailsBuilder.flush().addMethodName("onPluginDeactivated").addArguments(pluginMap)
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginFileRequest(plugin: DytePlugin) {
    val pluginMap: Map<String, Any?> =
      mapOf(
        "id" to plugin.id,
        "name" to plugin.name,
        "description" to plugin.description,
        "picture" to plugin.picture,
        "private" to plugin.isPrivate,
        "staggered" to plugin.staggered,
        "baseURL" to plugin.baseURL,
      )
    callDetailsBuilder
      .flush()
      .addMethodName("onPluginFileRequest")
      .addArguments(hashMapOf("plugin" to pluginMap))
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginMessage(message: JsonObject) {
    callDetailsBuilder
      .flush()
      .addMethodName("onPluginMessage")
      .addArguments(hashMapOf("message" to message))
    sink.success(callDetailsBuilder.build())
  }
}
