package io.dyte.flutter_core_kmm.listeners

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.listeners.DyteRecordingEventsListener
import io.dyte.flutter_core_kmm.CallDetailsBuilder
import io.dyte.flutter_core_kmm.DyteSink

class RecordingEventsListener(private val sink: DyteSink) : DyteRecordingEventsListener {
  private val callDetails = CallDetailsBuilder()

  override fun onMeetingRecordingEnded() {
    val recordingDetails = callDetails.flush().addMethodName("onMeetingRecordingEnded").build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStarted() {
    val recordingDetails = callDetails.flush().addMethodName("onMeetingRecordingStarted").build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStateUpdated(state: DyteRecordingState) {
    val status = state.toMap()["state"]
    val recordingDetails =
      callDetails
        .flush()
        .addMethodName("onMeetingRecordingStateUpdated")
        .addArguments(hashMapOf("recordingState" to status))
        .build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStopError(e: Exception) {
    val recordingDetails =
      callDetails
        .flush()
        .addMethodName("onMeetingRecordingStopError")
        .addArguments(hashMapOf())
        .build()

    sink.success(recordingDetails)
  }
}
