package io.dyte.flutter_core_kmm.listeners

import io.dyte.core.controllers.DyteLivestreamData
import io.dyte.core.listeners.DyteLiveStreamEventsListener
import io.dyte.flutter_core_kmm.CallDetailsBuilder
import io.dyte.flutter_core_kmm.DyteSink

class LivestreamEventsListener(private val sink: DyteSink) : DyteLiveStreamEventsListener {
  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onLiveStreamEnded() {
    super.onLiveStreamEnded()

    callDetailsBuilder.flush().addMethodName("onLiveStreamEnded")

    sink.success(callDetailsBuilder.build())
  }

  override fun onLiveStreamErrored() {
    super.onLiveStreamErrored()

    callDetailsBuilder.flush().addMethodName("onLiveStreamErrored")

    sink.success(callDetailsBuilder.build())
  }

  override fun onLiveStreamStarting() {
    super.onLiveStreamStarting()

    callDetailsBuilder.flush().addMethodName("onLiveStreamStarting")

    sink.success(callDetailsBuilder.build())
  }

  override fun onLiveStreamStarted() {
    super.onLiveStreamStarted()

    callDetailsBuilder.flush().addMethodName("onLiveStreamStarted")

    sink.success(callDetailsBuilder.build())
  }

  override fun onLiveStreamStateUpdate(data: DyteLivestreamData) {
    super.onLiveStreamStateUpdate(data)

    callDetailsBuilder
      .flush()
      .addMethodName("onLiveStreamStateUpdate")
      .addArguments(hashMapOf("data" to data.toMap()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onLiveStreamEnding() {
    super.onLiveStreamEnding()

    callDetailsBuilder.flush().addMethodName("onLiveStreamEnding")

    sink.success(callDetailsBuilder.build())
  }

  override fun onViewerCountUpdated(count: Int) {
    super.onViewerCountUpdated(count)

    callDetailsBuilder
      .flush()
      .addMethodName("onViewerCountUpdated")
      .addArguments(hashMapOf("count" to count))

    sink.success(callDetailsBuilder.build())
  }

  override fun onStageCountUpdated(count: Int) {
    super.onStageCountUpdated(count)

    callDetailsBuilder
      .flush()
      .addMethodName("onStageCountUpdated")
      .addArguments(hashMapOf("count" to count))

    sink.success(callDetailsBuilder.build())
  }
}
