package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DyteChatMessage
import io.dyte.core.feat.encodeDyteChatMessage
import io.dyte.core.listeners.DyteChatEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class ChatEventsListener(private val sink: DyteSink) : DyteChatEventsListener {

  private val callDetails = CallDetailsBuilder()

  override fun onChatUpdates(messages: List<DyteChatMessage>) {
    val chatUpdateDetails =
      callDetails
        .flush()
        .addMethodName("onChatUpdates")
        .addArguments(hashMapOf("messages" to messages.map { encodeDyteChatMessage(it) }))
        .build()
    sink.success(chatUpdateDetails)
  }

  override fun onNewChatMessage(message: DyteChatMessage) {
    val chatUpdateDetails =
      callDetails
        .flush()
        .addMethodName("onNewChatMessage")
        .addArguments(hashMapOf("message" to encodeDyteChatMessage(message)))
        .build()
    sink.success(chatUpdateDetails)
  }
}
