package io.dyte.mobilecorebridge

import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
import android.net.Uri

actual class DyteUtils(private val context: Context) {

  actual fun launchUrl(url: String): Boolean {
    return try {
      val formattedUrl =
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
          "http://$url"
        } else {
          url
        }
      val webpage: Uri = Uri.parse(formattedUrl)
      val intent =
        Intent(Intent.ACTION_VIEW, webpage).apply {
          addCategory(Intent.CATEGORY_BROWSABLE)
          flags = Intent.FLAG_ACTIVITY_NEW_TASK
        }

      context.startActivity(intent)
      true
    } catch (e: ActivityNotFoundException) {
      false
    }
  }
}
