package io.dyte.mobilecorebridge.listeners

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.listeners.DyteRecordingEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class RecordingEventsListener(private val sink: DyteSink) : DyteRecordingEventsListener {
  private val callDetails = CallDetailsBuilder()

  override fun onMeetingRecordingEnded() {
    val recordingDetails = callDetails.flush().addMethodName("onMeetingRecordingEnded").build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStarted() {
    val recordingDetails = callDetails.flush().addMethodName("onMeetingRecordingStarted").build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStateUpdated(state: DyteRecordingState) {
    val status = state.toMap()["state"]
    val recordingDetails =
      callDetails
        .flush()
        .addMethodName("onMeetingRecordingStateUpdated")
        .addArguments(hashMapOf("recordingState" to status))
        .build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingStopError(e: Exception) {
    val recordingDetails =
      callDetails
        .flush()
        .addMethodName("onMeetingRecordingStopError")
        .addArguments(hashMapOf("error" to e.toString()))
        .build()

    sink.success(recordingDetails)
  }

  override fun onMeetingRecordingPauseError(e: Exception) {
    super.onMeetingRecordingPauseError(e)

    callDetails
      .flush()
      .addMethodName("onMeetingRecordingPauseError")
      .addArguments(hashMapOf("error" to e.toString()))
      .build()
  }

  override fun onMeetingRecordingResumeError(e: Exception) {
    super.onMeetingRecordingResumeError(e)

    callDetails
      .flush()
      .addMethodName("onMeetingRecordingResumeError")
      .addArguments(hashMapOf("error" to e.toString()))
      .build()
  }
}
