package io.dyte.mobilecorebridge.listeners

import io.dyte.core.controllers.DyteLivestreamData
import io.dyte.core.feat.DytePlugin
import io.dyte.core.listeners.DyteDataUpdateListener
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.network.info.DyteDesignToken
import io.dyte.core.network.info.SelfPermissions
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

class DataUpdateListener(private val sink: DyteSink) : DyteDataUpdateListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onMetaUpdate(
    roomName: String,
    meetingTitle: String,
    meetingStartedTimestamp: String,
    roomType: String,
    designToken: DyteDesignToken,
  ) {
    val mapOfDesignToken: HashMap<String, Any> =
      hashMapOf(
        "borderRadiusType" to Json.encodeToString(designToken.borderRadius),
        "borderWidth" to Json.encodeToString(designToken.borderWidth),
        "colors" to Json.encodeToString(designToken.colors),
      )
    callDetailsBuilder
      .flush()
      .addMethodName("onMetaUpdate")
      .addArguments(
        hashMapOf(
          "roomName" to roomName,
          "meetingTitle" to meetingTitle,
          "meetingStartedTimestamp" to meetingStartedTimestamp,
          "roomType" to roomType,
          "designToken" to mapOfDesignToken,
        )
      )
    sink.success(callDetailsBuilder.build())
  }

  override fun onSelfPermissionsUpdate(permission: SelfPermissions) {
    val permissions: MutableMap<Any?, Any?> = permission.toMap().toMutableMap()

    (permissions["chat"] as MutableMap<String, Any?>)["canSend"] = permission.chat.canSend

    callDetailsBuilder
      .flush()
      .addMethodName("onSelfPermissionsUpdate")
      .addArguments(hashMapOf("selfPermissions" to permissions))
    sink.success(callDetailsBuilder.build())
  }

  override fun onPluginsUpdates(plugins: List<DytePlugin>) {
    val pluginsMap =
      plugins.map {
        mapOf(
          "id" to it.id,
          "name" to it.name,
          "description" to it.description,
          "picture" to it.picture,
          "private" to it.isPrivate,
          "staggered" to it.staggered,
          "baseURL" to it.baseURL,
        )
      }
    callDetailsBuilder
      .flush()
      .addMethodName("onPluginsUpdates")
      .addArguments(hashMapOf("plugins" to pluginsMap))
    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareUpdate(screenShares: List<DyteJoinedMeetingParticipant>) {
    callDetailsBuilder
      .flush()
      .addMethodName("onScreenShareUpdate")
      .addArguments(hashMapOf("screenShares" to screenShares.map { it.toMap() }))
    sink.success(callDetailsBuilder.build())
  }

  override fun onLivestreamUpdate(liveStream: DyteLivestreamData) {

    callDetailsBuilder
      .flush()
      .addMethodName("onLivestreamUpdate")
      .addArguments(hashMapOf("livestreamData" to liveStream.toMap()))

    sink.success(callDetailsBuilder.build())
  }
}
