package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DyteWaitlistedParticipant
import io.dyte.core.listeners.DyteWaitlistEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class WaitingRoomEventsListener(private var sink: DyteSink) : DyteWaitlistEventsListener {
  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onWaitListParticipantAccepted(participant: DyteWaitlistedParticipant) {
    super.onWaitListParticipantAccepted(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onWaitListParticipantAccepted")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onWaitListParticipantClosed(participant: DyteWaitlistedParticipant) {
    super.onWaitListParticipantClosed(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onWaitListParticipantClosed")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onWaitListParticipantJoined(participant: DyteWaitlistedParticipant) {
    super.onWaitListParticipantJoined(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onWaitListParticipantJoined")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onWaitListParticipantRejected(participant: DyteWaitlistedParticipant) {
    super.onWaitListParticipantRejected(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onWaitListParticipantRejected")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }
}
