package io.dyte.mobilecorebridge.listeners

import io.dyte.core.controllers.DyteStageStatus
import io.dyte.core.listeners.DyteSelfEventsListener
import io.dyte.core.models.DyteSelfParticipant
import io.dyte.core.models.DyteVideoDevice
import io.dyte.core.models.WaitListStatus
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class SelfParticipantListener(private val sink: DyteSink) : DyteSelfEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onAudioDevicesUpdated() {
    super.onAudioDevicesUpdated()
    callDetailsBuilder.flush().addMethodName("onAudioDevicesUpdated")
    sink.success(callDetailsBuilder.build())
  }

  override fun onAudioUpdate(audioEnabled: Boolean) {
    super.onAudioUpdate(audioEnabled)
    callDetailsBuilder
      .flush()
      .addMethodName("onAudioUpdate")
      .addArguments(hashMapOf("audioEnabled" to audioEnabled))
    sink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomJoinedWithoutCameraPermission() {
    super.onMeetingRoomJoinedWithoutCameraPermission()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomJoinedWithoutCameraPermission")
    sink.success(callDetailsBuilder.build())
  }

  override fun onMeetingRoomJoinedWithoutMicPermission() {
    super.onMeetingRoomJoinedWithoutMicPermission()
    callDetailsBuilder.flush().addMethodName("onMeetingRoomJoinedWithoutMicPermission")
    sink.success(callDetailsBuilder.build())
  }

  override fun onProximityChanged(isNear: Boolean) {
    super.onProximityChanged(isNear)
    callDetailsBuilder
      .flush()
      .addMethodName("onProximityChanged")
      .addArguments(hashMapOf("isNear" to isNear))
    sink.success(callDetailsBuilder.build())
  }

  override fun onRemovedFromMeeting() {
    super.onRemovedFromMeeting()
    callDetailsBuilder.flush().addMethodName("onRemovedFromMeeting")
    sink.success(callDetailsBuilder.build())
  }

  override fun onUpdate(participant: DyteSelfParticipant) {
    super.onUpdate(participant)
    callDetailsBuilder
      .flush()
      .addMethodName("onUpdate")
      .addArguments(
        hashMapOf(
          "participant" to participant.toMap(),
          "selfPermissions" to participant.toMap()["selfPermissions"],
        )
      )
    sink.success(callDetailsBuilder.build())
  }

  override fun onVideoUpdate(videoEnabled: Boolean) {
    super.onVideoUpdate(videoEnabled)
    callDetailsBuilder
      .flush()
      .addMethodName("onVideoUpdate")
      .addArguments(hashMapOf("videoEnabled" to videoEnabled))
    sink.success(callDetailsBuilder.build())
  }

  override fun onWaitListStatusUpdate(waitListStatus: WaitListStatus) {
    super.onWaitListStatusUpdate(waitListStatus)
    val status: String
    status =
      when (waitListStatus) {
        WaitListStatus.WAITING -> "waiting"
        WaitListStatus.ACCEPTED -> "accepted"
        WaitListStatus.REJECTED -> "rejected"
        WaitListStatus.NONE -> "none"
      }

    callDetailsBuilder
      .flush()
      .addMethodName("onWaitListStatusUpdate")
      .addArguments(hashMapOf("waitlistStatus" to status))

    sink.success(callDetailsBuilder.build())
  }

  override fun onRoomMessage(type: String, payload: Map<String, *>) {
    super.onRoomMessage(type, payload)

    callDetailsBuilder
      .flush()
      .addMethodName("onRoomMessage")
      .addArguments(hashMapOf("type" to type, "payload" to payload))

    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareStartFailed(reason: String) {
    super.onScreenShareStartFailed(reason)

    callDetailsBuilder
      .flush()
      .addMethodName("onScreenShareStartFailed")
      .addArguments(hashMapOf("reason" to reason))

    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareStarted() {
    super.onScreenShareStarted()

    callDetailsBuilder.flush().addMethodName("onScreenShareStarted")

    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareStopped() {
    super.onScreenShareStopped()

    callDetailsBuilder.flush().addMethodName("onScreenShareStopped")

    sink.success(callDetailsBuilder.build())
  }

  override fun onStageStatusUpdated(stageStatus: DyteStageStatus) {
    super.onStageStatusUpdated(stageStatus)

    callDetailsBuilder
      .flush()
      .addMethodName("onStageStatusUpdated")
      .addArguments(hashMapOf("stageStatus" to stageStatus.toString()))

    sink.success(callDetailsBuilder.build())
  }

  override fun onVideoDeviceChanged(videoDevice: DyteVideoDevice) {
    super.onVideoDeviceChanged(videoDevice)

    callDetailsBuilder
      .flush()
      .addMethodName("onVideoDeviceChanged")
      .addArguments(hashMapOf("videoDevice" to videoDevice.toMap()))

    sink.success(callDetailsBuilder.build())
  }
}
