package io.dyte.mobilecorebridge.listeners

import io.dyte.core.feat.DytePollMessage
import io.dyte.core.listeners.DytePollEventsListener
import io.dyte.mobilecorebridge.CallDetailsBuilder
import io.dyte.mobilecorebridge.DyteSink

class PollsEventsListener(private val sink: DyteSink) : DytePollEventsListener {

  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onNewPoll(poll: DytePollMessage) {
    callDetailsBuilder
      .flush()
      .addMethodName("onNewPoll")
      .addArguments(hashMapOf("poll" to poll.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onPollUpdates(pollMessages: List<DytePollMessage>) {
    callDetailsBuilder
      .flush()
      .addMethodName("onPollUpdates")
      .addArguments(hashMapOf("pollMessages" to pollMessages.map { it.toMap() }))
    sink.success(callDetailsBuilder.build())
  }
}
