package io.dyte.flutter_core_kmm.listeners

import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.listeners.DyteParticipantUpdateListener
import io.dyte.flutter_core_kmm.CallDetailsBuilder
import io.dyte.flutter_core_kmm.DyteSink

class ParticipantUpdateEventsListener(private val sink: DyteSink) : DyteParticipantUpdateListener {
  private val callDetailsBuilder = CallDetailsBuilder()

  override fun onAudioUpdate(isEnabled: Boolean) {
    super.onAudioUpdate(isEnabled)
    callDetailsBuilder
      .flush()
      .addMethodName("onAudioUpdate")
      .addArguments(hashMapOf("isEnabled" to isEnabled))
    sink.success(callDetailsBuilder.build())
  }

  override fun onPinned() {
    super.onPinned()
    callDetailsBuilder.flush().addMethodName("onPinned")

    sink.success(callDetailsBuilder.build())
  }

  override fun onRemovedAsActiveSpeaker() {
    super.onRemovedAsActiveSpeaker()
    callDetailsBuilder.flush().addMethodName("onRemovedAsActiveSpeaker")

    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareEnded() {
    super.onScreenShareEnded()

    callDetailsBuilder.flush().addMethodName("onScreenShareEnded")

    sink.success(callDetailsBuilder.build())
  }

  override fun onScreenShareStarted() {
    super.onScreenShareStarted()

    callDetailsBuilder.flush().addMethodName("onScreenShareStarted")
    sink.success(callDetailsBuilder.build())
  }

  override fun onSetAsActiveSpeaker() {
    super.onSetAsActiveSpeaker()

    callDetailsBuilder.flush().addMethodName("onSetAsActiveSpeaker")
    sink.success(callDetailsBuilder.build())
  }

  override fun onUnpinned() {
    super.onUnpinned()
    callDetailsBuilder.flush().addMethodName("onUnpinned")
    sink.success(callDetailsBuilder.build())
  }

  override fun onUpdate(participant: DyteMeetingParticipant) {
    super.onUpdate(participant)

    callDetailsBuilder
      .flush()
      .addMethodName("onUpdate")
      .addArguments(hashMapOf("participant" to participant.toMap()))
    sink.success(callDetailsBuilder.build())
  }

  override fun onVideoUpdate(isEnabled: Boolean) {
    super.onVideoUpdate(isEnabled)

    callDetailsBuilder
      .flush()
      .addMethodName("onVideoUpdate")
      .addArguments(hashMapOf("isEnabled" to isEnabled))
    sink.success(callDetailsBuilder.build())
  }
}
