package io.dyte.flutter_core_kmm

class CallDetailsBuilder {

  private val callDetails = HashMap<String, Any?>()

  fun addMethodName(name: String): CallDetailsBuilder {
    callDetails["name"] = name
    return this
  }

  fun addArguments(args: HashMap<String, Any?>): CallDetailsBuilder {
    callDetails["args"] = args
    return this
  }

  fun flush(): CallDetailsBuilder {
    callDetails.clear()
    return this
  }

  fun build(): HashMap<String, Any?> {
    if (!callDetails.containsKey("args")) {
      callDetails["args"] = null
    }
    return callDetails
  }
}
