package io.dyte.media.hive

import kotlinx.serialization.Contextual
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive

/** DC Message is type for data channel message and consistent
 *  with Hive node DataChannelMessage
 */
@Serializable
class DCMessage(
  val type: String,
  val payload: Map<String, JsonPrimitive>
)

@Serializable
class DCMessageChunked(
  val id: String,
  val count: Int,
  val chunkIndex: Int,
  val chunk: String
)