package io.dyte.media.utils.sdp

import kotlinx.serialization.Serializable

@Serializable
data class Field(
    val name: String,
    val type: String,
    val optional: Boolean? = null
)

@Serializable
data class SDPObject (
    val name: String? = null,
    val reg: String,
    val format: String,
    val fields: List<Field>,
    val push: String?= null
)

@Serializable
data class SDPWrapper(
    val data: Map<String, List<SDPObject>>
)