package io.dyte.media.handlers.sdp

import io.dyte.webrtc.CommonRtpEncodingParameters

class UnifiedPlanUtils {
    companion object {
        fun getRtpEncodings(offerMediaObject: MediaObject): List<CommonRtpEncodingParameters> {
            val ssrcs: MutableSet<Long> = mutableSetOf<Long>()

            for(line: Ssrc in offerMediaObject.ssrcs ?: emptyList()) {
                val ssrc = requireNotNull(line.id)
                ssrcs.add(ssrc)
            }

            if (ssrcs.isEmpty()) throw Exception("No a=ssrc lines found")

            val ssrcToRtxSsrc: MutableMap<Any?, Any?> = mutableMapOf()

            for (line: SsrcGroup in offerMediaObject.ssrcGroups ?: emptyList()) {
                if (line.semantics != "FID") continue

                val tokens: List<String> = line.ssrcs.split(" ")

                var ssrc: Long? = null
                var rtxSsrc: Long? = null

                if (tokens.isNotEmpty()) {
                    ssrc = tokens[0].toLong()
                }

                if (tokens.size > 1) {
                    rtxSsrc = tokens[1].toLong()
                }

                if (ssrcs.contains(ssrc)) {
                    ssrcs.remove(ssrc)
                    ssrcs.remove(rtxSsrc)

                    ssrcToRtxSsrc[ssrc] = rtxSsrc
                }
            }

            for (ssrc in ssrcs) {
                ssrcToRtxSsrc[ssrc] = null
            }

            val encodings: MutableList<CommonRtpEncodingParameters> = mutableListOf()

            ssrcToRtxSsrc.forEach { map ->
                val(ssrc, rtxSsrc) = map

                val encoding  = CommonRtpEncodingParameters()
                encoding.ssrc = ssrc as Long?

                // [WIP] Missing entity rtx
//                if (rtxSsrc != null) encoding.rtx = RtxSsrc(rtxSsrc)

                encodings.add(encoding)
            }

            return encodings
        }

        fun addLegacySimulcast(offerMediaObject: MediaObject, numStreams: Int): Unit {
            if (numStreams <= 1) throw Exception("numStreams must be greater than 1")

            val ssrcMsidLine: Ssrc = (offerMediaObject.ssrcs ?: emptyList()).firstOrNull {
                it.attribute == "msid"
            } ?: throw Exception("ssrc line with msid information not found")

            val tmp: List<String> = requireNotNull(ssrcMsidLine.value.split(" "))

            var streamId: String = ""
            var trackId: String = ""

            if (tmp.size > 0) streamId = tmp[0]
            if (tmp.size > 1) trackId = tmp[1]

            val firstSsrc: Long? = ssrcMsidLine.id
            var firstRtxSsrc: Int? = null

            (offerMediaObject.ssrcGroups ?: emptyList()).any {
                if (it.semantics != "FID") false

                val ssrcs: List<String> = it.ssrcs.split(" ")

                if (ssrcs[0].toLong() == firstSsrc) {
                    firstRtxSsrc = ssrcs[1].toInt()
                    true
                } else {
                    false
                }
            }

            val ssrcCnameLine: Ssrc? = (offerMediaObject.ssrcs)?.firstOrNull {
                it.attribute == "cname"
            } ?: throw Exception("ssrc line with cname information not found")

            val cname: String = ssrcCnameLine!!.value
            val ssrcs: MutableList<Long> = mutableListOf()
            val rtxSsrcs: MutableList<Int> = mutableListOf()

            for(i: Int in 0 until numStreams) {
                ssrcs.add(requireNotNull(firstSsrc) + i)
                rtxSsrcs.add(requireNotNull(firstRtxSsrc) + i)
            }

            offerMediaObject.ssrcGroups = mutableListOf()
            offerMediaObject.ssrcs = mutableListOf()

            offerMediaObject.ssrcGroups!!.add(
                SsrcGroup(
                    semantics = "SIM",
                    ssrcs = ssrcs.joinToString(" ")
                )
            )

            for (i: Int in 0 until ssrcs.size) {
                val ssrc = ssrcs[i]

                requireNotNull(offerMediaObject.ssrcs).add(
                    Ssrc(
                        id = ssrc,
                        attribute = "cname",
                        value = cname
                    )
                )

                requireNotNull(offerMediaObject.ssrcs).add(
                    Ssrc(
                        id = ssrc,
                        attribute = "msid",
                        value = "$streamId $trackId"
                    )
                )
            }

            for (i: Int in 0 until rtxSsrcs.size) {
                val ssrc = ssrcs[i]
                val rtxSsrc: Int = rtxSsrcs[i]

                requireNotNull(offerMediaObject.ssrcs).add(
                    Ssrc(
                        id = rtxSsrc.toLong(),
                        attribute = "cname",
                        value = cname
                    )
                )

                requireNotNull(offerMediaObject.ssrcs).add(
                    Ssrc(
                        id = rtxSsrc.toLong(),
                        attribute = "msid",
                        value = "$streamId $trackId"
                    )
                )

                requireNotNull(offerMediaObject.ssrcGroups).add(
                    SsrcGroup(
                        semantics = "FID",
                        ssrcs = "$ssrc $rtxSsrc"
                    )
                )

            }

        }
    }
}