package io.dyte.media.hive

import io.dyte.webrtc.RtpTransceiverDirection
import io.dyte.media.hive.handlers.HiveHandlerFactory
import io.dyte.media.hive.handlers.HiveUnifiedPlan
import io.dyte.media.utils.UUIDUtils
import kotlinx.coroutines.flow.MutableSharedFlow

class HiveDeviceOptions(
  /** The name of one of the builtin handlers, only unified plan in our case */
  val handlerName: String = "UnifiedPlan",
  /** Custom handler factory */
  val handlerFactory: HiveHandlerFactory = HiveUnifiedPlan.createFactory()
)

class HiveDevice(options: HiveDeviceOptions) {
  /** RTC handler factory */
  private val _handlerFactory = options.handlerFactory

  /** Handler name */
  private var _handlerName: String

  /** Observer */
  val observer = MutableSharedFlow<HiveEmitData>()

  init {
    // Create a temporal handler to get its name
    val handler = this._handlerFactory()

    this._handlerName = handler.getName()
  }

  /** The RTC handler name */
  fun getHandlerName() = this._handlerName

  /** Creates Transport for sending media */
  suspend fun createSendTransport(options: HiveTransportOptions): HiveTransport {
    println("DyteMediaClient: createSendTransport()")

    return this._createTransport(
      HiveInternalTransportOptions(
      direction = RtpTransceiverDirection.SendOnly,
      iceServers = options.iceServers!!,
      iceTransportPolicy = options.iceTransportPolicy!!,
      additionalSettings = options.additionalSettings,
      proprietaryConstraints = options.proprietaryConstraints,
      appData = options.appData
    )
    )
  }

  suspend fun createRecvTransport(options: HiveTransportOptions): HiveTransport {
    println("DyteMediaClient: createRecvTransport()")

    return this._createTransport(
      HiveInternalTransportOptions(
      direction = RtpTransceiverDirection.RecvOnly,
      iceServers = options.iceServers!!,
      iceTransportPolicy = options.iceTransportPolicy!!,
      additionalSettings = options.additionalSettings,
      proprietaryConstraints = options.proprietaryConstraints,
      appData = options.appData
    )
    )
  }

  private suspend fun _createTransport(options: HiveInternalTransportOptions): HiveTransport {
    val id = UUIDUtils.getRandom()

    // Create a new Transport
    val transport = HiveTransport(
      HiveInternalTransportOptions(
      id = id,
      direction = options.direction,
      iceServers = options.iceServers,
      iceTransportPolicy = options.iceTransportPolicy,
      additionalSettings = options.additionalSettings,
      proprietaryConstraints = options.proprietaryConstraints,
      appData = options.appData,
      handlerFactory = this._handlerFactory
    )
    )

    this.observer.emit(HiveEmitData("newtransport", transport))

    return transport
  }
}