package io.dyte.media.common

import io.dyte.webrtc.CommonRtpEncodingParameters
import io.dyte.webrtc.MediaStream
import io.dyte.webrtc.MediaStreamTrack

typealias MediaAppData = Map<String, Any>

class MediaProducerOptions(
  val track: MediaStreamTrack?,
  val stream: MediaStream,
  val encodings: List<CommonRtpEncodingParameters>?,
  val codecOptions: List<MediaCodecOptions>?,
  val stopTracks: Boolean?,
  val disableTrackOnPause: Boolean?,
  val zeroRtpOnPause: Boolean?,
  val appData: MediaAppData?,
)

class MediaInternalProducerOptions(
  val id: String,
  val localId: String,
  val track: MediaStreamTrack,
  val stopTracks: Boolean,
  val disableTrackOnPause: Boolean,
  val zeroRtpOnPause: Boolean,
  val handler: MediaHandlerInterface,
  val appData: MediaAppData,
)

data class PeerProducerMeta(
  var producerId: String,
  var producingPeerId: String,
  var producingTransportId: String,
  var kind: String,
  var paused: Boolean,
  var screenShare: Boolean,
  var peerId: String,
  var mimeType: String,
)
