package io.dyte.media.common

import io.dyte.webrtc.IceGatheringState
import io.dyte.webrtc.SessionDescription

sealed class MediaEvents

sealed class UnifiedPlanEvents : MediaEvents() {
  class DataChannelMessage(val map: Map<String, Any?>) : UnifiedPlanEvents()

  class ConnectionStateChange(val state: SfuMediaConnectionState) : UnifiedPlanEvents()

  class IceGatheringStateChange(val state: IceGatheringState) : UnifiedPlanEvents()

  class IceCandidate(val candidate: io.dyte.webrtc.IceCandidate) : UnifiedPlanEvents()

  object NegotiationNeeded : UnifiedPlanEvents()
}

sealed class SfuMediaEvents : MediaEvents() {
  class Negotiate(val sdp: SessionDescription) : SfuMediaEvents()

  class NewTransport(val device: MediaDevice) : SfuMediaEvents()

  class ReconnectTransport(val transport: MediaTransport) : SfuMediaEvents()

  class NewConsumer(val consumer: MediaConsumer) : SfuMediaEvents()

  class NewProducer(val producer: MediaProducer) : SfuMediaEvents()

  class Close(val reason: String? = null, val result: MediaGenericHandlerResult? = null) :
    SfuMediaEvents()

  class Connect(val sdp: SessionDescription) : SfuMediaEvents()

  class ConnectAnswer(val sdp: SessionDescription) : SfuMediaEvents()

  class Produce(val map: Map<String, Any?>) : SfuMediaEvents()

  class ProduceAnswer(val map: Map<String, Any?>) : SfuMediaEvents()

  class Rejoin(val force: Boolean = false) : SfuMediaEvents()

  object Connected : SfuMediaEvents()

  object Disconnected : SfuMediaEvents()

  object Pause : SfuMediaEvents()

  object Resume : SfuMediaEvents()

  object TrackEnded : SfuMediaEvents()

  class ConnectionStateChanged(val state: SfuMediaConnectionState) : SfuMediaEvents()

  class IceCandidate(val candidate: io.dyte.webrtc.IceCandidate) : SfuMediaEvents()

  class DataChannelMessage(val map: Map<String, Any?>) : SfuMediaEvents()

  class ConsumePeer(val producers: List<PeerProducerMeta>) : SfuMediaEvents()

  class CfConsumePeerAnswer(
    val sdp: SessionDescription,
    val consumersMap: Map<String, MediaConsumerStateObject>,
  ) : SfuMediaEvents()

  class HiveConsumePeerAnswer(val value: Map<String, HiveConsumerState>) : SfuMediaEvents()
}
