package io.dyte.media.common

import io.dyte.webrtc.MediaStreamTrack
import io.dyte.webrtc.MediaStreamTrackKind

abstract class MediaConsumerOptions(
  open val id: String?,
  open val producerId: String,
  open val producingPeerId: String,
  open val producingTransportId: String,
  open val kind: MediaStreamTrackKind,
  open var paused: Boolean?,
  open val appData: Map<String, Any>?,
  open var mimeType: String?,
)

class MediaInternalConsumerOptions(
  override val id: String?,
  override val producerId: String,
  override val producingPeerId: String,
  override val producingTransportId: String,
  override val kind: MediaStreamTrackKind,
  override var paused: Boolean?,
  override var mimeType: String?,
  override val appData: Map<String, Any>?,
  val localId: String,
  val handler: MediaHandlerInterface,
  val track: MediaStreamTrack?,
  val reuseTrack: Boolean? = null,
  val ssrc: Long? = null,
) :
  MediaConsumerOptions(
    id,
    producerId,
    producingPeerId,
    producingTransportId,
    kind,
    paused,
    appData,
    mimeType,
  )

class MediaConsumerCreationTaskOptions(
  override val consumerId: String,
  override val trackId: String,
  override val streamId: String,
  override val screenShare: Boolean,
  override val paused: Boolean,
  override val kind: MediaStreamTrackKind,
  override val producingPeerId: String,
  override val producingTransportId: String,
  override val mimeType: String,
  val producerId: String,
  val appData: MutableMap<String, Any>,
) :
  HiveConsumerStateObject(
    consumerId,
    trackId,
    streamId,
    screenShare,
    paused,
    kind,
    producingTransportId,
    mimeType,
    producingPeerId,
  )

class MediaConsumerStateObject(
  val consumerId: String,
  val trackId: String,
  val streamId: String,
  val screenShare: Boolean,
  val paused: Boolean,
  val kind: MediaStreamTrackKind,
  val producingTransportId: String,
  val producingPeerId: String,
) {
  override fun toString(): String {
    return "MediaConsumerStateObject(consumerId='$consumerId', trackId='$trackId', streamId='$streamId', screenShare=$screenShare, paused=$paused, kind=$kind, producingTransportId='$producingTransportId', producingPeerId='$producingPeerId')"
  }
}
