package io.dyte.media.handlers.sdp

import io.dyte.media.PlainRtpParameters
import io.dyte.media.SdpObject
import io.dyte.media.utils.RTCRtpMediaType
import io.dyte.webrtc.CommonRtpEncodingParameters

class PlainRtpUtils {
  companion object {
    fun extractPlainRtpParameters(sdpObject: SdpObject, kind: RTCRtpMediaType): PlainRtpParameters {
      val mediaObject: MediaObject? =
        sdpObject.media.firstOrNull { it.type == RTCRtpMediaType.value(kind) }
          ?: throw Exception("${RTCRtpMediaType.value(kind)} section not found")

      val connectionObject: Connection =
        requireNotNull(mediaObject?.connection ?: sdpObject.connection)
      val result =
        PlainRtpParameters(
          ip = connectionObject.ip,
          _ipVersion = connectionObject.version,
          port = requireNotNull(mediaObject?.port),
        )

      return result
    }

    fun getRtpEncodings(
      sdpObject: SdpObject,
      kind: RTCRtpMediaType,
    ): List<CommonRtpEncodingParameters> {
      val mediaObject: MediaObject? =
        sdpObject.media.firstOrNull { it.type == RTCRtpMediaType.value(kind) }
          ?: throw Exception("${RTCRtpMediaType.value(kind)} section not found")

      if (mediaObject != null || mediaObject?.ssrcs!!.isNotEmpty()) {
        val ssrc: Ssrc = requireNotNull(mediaObject.ssrcs).first()

        val result = CommonRtpEncodingParameters()
        result.ssrc = ssrc.id

        return listOf(result!!)
      }

      return emptyList<CommonRtpEncodingParameters>()
    }
  }
}
