package io.dyte.media.common

import io.dyte.webrtc.IceServer
import io.dyte.webrtc.IceTransportPolicy
import io.dyte.webrtc.MediaStreamTrack
import io.dyte.webrtc.MediaStreamTrackKind
import io.dyte.webrtc.RtpReceiver
import io.dyte.webrtc.RtpTransceiver
import io.dyte.webrtc.RtpTransceiverDirection

enum class SfuMediaConnectionState {
  New,
  Connecting,
  Connected,
  Failed,
  Disconnected,
  Closed
}

enum class MediaNodeType(val value: Int) {
  HIVE(1),
  ROOM_NODE(2),
  CF(3);

  companion object {
    fun fromInt(value: Int) = entries.first { it.value == value }
  }
}

open class MediaTransportOptions(
  open val iceServers: List<IceServer>? = null,
  open val iceTransportPolicy: IceTransportPolicy? = null,
  open val additionalSettings: MutableMap<String, Any>? = null,
  open val proprietaryConstraints: Any? = null,
  open val appData: Map<String, Any>? = null,
)

class MediaInternalTransportOptions(
  val id: String? = null,
  val direction: RtpTransceiverDirection,
  val handlerFactory: MediaHandlerFactory? = null,
  override val iceServers: List<IceServer>,
  override val iceTransportPolicy: IceTransportPolicy?,
  override val additionalSettings: MutableMap<String, Any>?,
  override val proprietaryConstraints: Any?,
  override val appData: Map<String, Any>?,
) :
  MediaTransportOptions(
    iceServers,
    iceTransportPolicy,
    additionalSettings,
    proprietaryConstraints,
    appData,
  )

typealias consumerTrackEventHandler = suspend (ConsumerTrackEvent) -> Unit

open class HiveConsumerStateObject(
  open val consumerId: String,
  open val trackId: String,
  open val streamId: String,
  open val screenShare: Boolean,
  open val paused: Boolean,
  open val kind: MediaStreamTrackKind,
  open val producingTransportId: String,
  open val producingPeerId: String,
  open val mimeType: String,
) {
  override fun toString(): String {
    return "ConsumerStateObject(consumerId='$consumerId', trackId='$trackId', streamId='$streamId', screenShare=$screenShare, paused=$paused, kind=$kind, producingTransportId='$producingTransportId')"
  }
}

class HiveConsumerState(
  val producerId: String,
  val consumerId: String,
  val trackId: String,
  val streamId: String,
) {
  override fun toString(): String {
    return "ConsumerState(producerId='$producerId', consumerId='$consumerId', trackId='$trackId', streamId='$streamId')"
  }
}

class HiveConsumerCreationTaskException(
  val options: MediaConsumerCreationTaskOptions,
  var isTimedOut: Boolean = false,
  val name: String = "Consumer Creation Task Exception",
  override val message: String = "Consumer Creation Failed",
) : Exception(message)

class ConsumerTrackEvent(
  val mid: String,
  val receiver: RtpReceiver,
  val track: MediaStreamTrack? = null,
  val transceiver: RtpTransceiver? = null,
)

abstract class MediaEmitData(val event: MediaEvents)

class UnifiedPlanEmitData(event: UnifiedPlanEvents) : MediaEmitData(event)

class SfuMediaEmitData(event: SfuMediaEvents) : MediaEmitData(event)
