package io.dyte.media.utils

import io.dyte.webrtc.SessionDescriptionType

class SessionDescriptionUtils {
  companion object {
    private val types: Map<String, SessionDescriptionType> =
      mapOf(
        "offer" to SessionDescriptionType.Offer,
        "answer" to SessionDescriptionType.Answer,
        "pranswer" to SessionDescriptionType.Pranswer,
        "rollback" to SessionDescriptionType.Rollback,
      )

    fun fromString(i: String): SessionDescriptionType = requireNotNull(types[i])
  }
}
