package io.dyte.media

class ScalabilityMode(
    val spatialLayers: Int,
    val temporalLayers: Int,
) {
    companion object {
        val scalabilityModeRegex = Regex("^[LS]([1-9]\\\\d{0,1})T([1-9]\\\\d{0,1})")

        fun parse(scalabilityMode: String?): ScalabilityMode {
            val match = scalabilityModeRegex.findAll(scalabilityMode ?: "").toList()

            if(match.isNotEmpty()) {
                return ScalabilityMode(
                    spatialLayers = requireNotNull(match.elementAt(0).groups[1]?.value?.toInt()),
                    temporalLayers = requireNotNull(match.elementAt(0).groups[1]?.value?.toInt())
                )
            } else {
                return ScalabilityMode(
                    spatialLayers = 1,
                    temporalLayers = 1
                )
            }
        }
    }
}