package io.dyte.media

import io.dyte.media.utils.Priority
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@Serializable
@OptIn(ExperimentalSerializationApi::class)
class NumSctpStreams(
  @JsonNames("OS") val os: Int,
  @JsonNames("MIS") val mis: Int,
)

@Serializable
@OptIn(ExperimentalSerializationApi::class)
class SctpCapabilities(@JsonNames("numStreams") val numStreams: NumSctpStreams)

@Serializable
@OptIn(ExperimentalSerializationApi::class)
class SctpParameters(
  @JsonNames("port") val port: Int = 5000,
  @JsonNames("OS") val os: Int,
  @JsonNames("MIS") val mis: Int,
  @JsonNames("maxMessageSize") val maxMessageSize: Int,
)

@Serializable
@OptIn(ExperimentalSerializationApi::class)
data class SctpStreamParameters(
  @JsonNames("streamId") val streamId: Int,
  @JsonNames("ordered") var ordered: Boolean? = null,
  @JsonNames("maxPacketLifeTime") val maxPacketLifeTime: Int? = null,
  @JsonNames("maxRetransmits") val maxRetransmits: Int? = null,
  @JsonNames("priority") val priority: Priority? = null,
  @JsonNames("label") val label: String? = null,
  @JsonNames("protocol") val protocol: String? = null,
)
