package io.dyte.media.hive.handlers

import io.dyte.webrtc.*

open class HiveGenericHandlerResult(
  open val offerSdp: SessionDescription,
  open val callback: suspend (answer: SessionDescription) -> Any
)

class HiveHandlerRunOptions(
  val direction: RtpTransceiverDirection,
  val iceServers: List<IceServer>?,
  val iceTransportPolicy: IceTransportPolicy?,
  val additionalSettings: Map<String, Any>?,
  val proprietaryConstraints: Any?,
  val onTrackHandler: suspend (event: TrackEvent) -> Unit
)

class HiveCodecOptions(
  val name: String,
  val parameters: List<String>?
)

class HiveHandlerSendOptions(
  val track: MediaStreamTrack,
  val screenShare: Boolean?,
  val encodings: List<CommonRtpEncodingParameters>? = null,
  val codecs: List<RtpCodecParameters>? = null, // Same as CodecCapability?
  val codecOptions: HiveCodecOptions?
)

class HiveHandlerSendResult(
  override val offerSdp: SessionDescription,
  override val callback: suspend (answer: SessionDescription) -> Any
): HiveGenericHandlerResult(offerSdp, callback)

class HiveHandlerReceiveResult(
  val track: MediaStreamTrack,
  val localId: String
)

class HiveHandlerReceiveDataChannelResult(
  val dataChannel: DataChannel
)

abstract class HiveHandlerInterface {
  /** Map of RtpTransceivers indexed by MID */
  val mapMidTransceiver: MutableMap<String, RtpTransceiver> = mutableMapOf()

  abstract fun getName(): String

  abstract fun getPc(): PeerConnection

  abstract fun close()

  abstract suspend fun init(options: HiveHandlerRunOptions)

  abstract suspend fun connect(): HiveGenericHandlerResult

  abstract suspend fun updateIceServers(iceServers: List<IceServer>)

  abstract suspend fun restartIce(): HiveGenericHandlerResult

  abstract suspend fun getTransportStats(): RtcStatsReport

  abstract suspend fun send(options: HiveHandlerSendOptions): HiveHandlerSendResult

  abstract suspend fun stopSending(localId: String): HiveGenericHandlerResult

  abstract suspend fun replaceTrack(localId: String, track: MediaStreamTrack?)

  abstract suspend fun setMaxSpatialLayer(localId: String, spatialLayer: Long)

  abstract suspend fun setRtpEncodingParameters(localId: String, params: Any)

  abstract fun getSenderStats(localId: String): List<RtcStatsReport>

//    We don't need this right now as receiving happens async with DataChannel base negotiation
//    abstract fun receive(answer: SessionDescription): HandlerReceiveResult

  abstract suspend fun stopReceiving(localId: String): HiveGenericHandlerResult

  abstract suspend fun pauseReceiving(localId: String): HiveGenericHandlerResult

  abstract suspend fun resumeReceiving(localId: String): HiveGenericHandlerResult

  abstract suspend fun getReceiverStats(localId: String): List<RtcStatsReport>
}

typealias HiveHandlerFactory = () -> HiveHandlerInterface