package io.dyte.media.utils

enum class Priority {
    VeryLow,
    Low,
    Medium,
    High;

    companion object {
        private val types: Map<String, Priority> = mapOf(
            "very-low" to VeryLow,
            "low" to Low,
            "medium" to Medium,
            "high" to High,
        )

        val values = mapOf(
            VeryLow to "very-low",
            Low to "low",
            Medium to "medium",
            High to "high",
        )

        fun fromString(i: String) : Priority = requireNotNull(types[i])

        fun value(p: Priority?): String = requireNotNull(values[p])
    }
}