package io.dyte.media

import io.dyte.webrtc.CommonRtpEncodingParameters

class ScalabilityMode(
  val spatialLayers: Int,
  val temporalLayers: Int,
) {
  companion object {
    val scalabilityModeRegex = Regex("^[LS]([1-9]\\\\d{0,1})T([1-9]\\\\d{0,1})")

    fun parse(encodings: List<CommonRtpEncodingParameters>): ScalabilityMode {
      if (encodings.size > 0) {
        var temporalLayers = 1
        if (encodings[0].numTemporalLayers != null) {
          temporalLayers = encodings[0].numTemporalLayers!!
        }
        return ScalabilityMode(
          spatialLayers = encodings.size,
          temporalLayers = temporalLayers,
        )
      } else {
        return ScalabilityMode(spatialLayers = 1, temporalLayers = 1)
      }
    }
  }
}
