package io.dyte.media.utils

import kotlinx.serialization.json.*

fun JsonObject.extend(elem: JsonObject): JsonObject {
    return JsonObject(
        toMutableMap()
            .apply {
                elem.forEach { (key, je) ->
                    put(key, je)
                }
            }
    )
}


fun JsonObject.update(key: String, value: JsonElement): JsonObject {
    return JsonObject(
        toMutableMap()
            .apply {
                put(key, value)
            }
    )
}

fun JsonObject.update(key: String, value: String): JsonObject {
    return JsonObject(
        toMutableMap()
            .apply {
                put(key, JsonPrimitive(value))
            }
    )
}

fun JsonObject.update(key: String, value: Int): JsonObject {
    return JsonObject(
        toMutableMap()
            .apply {
                put(key, JsonPrimitive(value))
            }
    )
}

fun JsonObject.update(key: String, value: Long): JsonObject {
    return JsonObject(
        toMutableMap()
            .apply {
                put(key, JsonPrimitive(value))
            }
    )
}


fun JsonArray.append(value: JsonElement): JsonArray {
    return JsonArray(
        toMutableList()
            .apply {
                add(value)
            }
    )
}

fun JsonArray.update(index: Int, value: JsonElement): JsonArray {
    return JsonArray(
        toMutableList()
            .apply {
                set(index,value)
            }
    )
}