package io.dyte.core.plugins

import io.dyte.core.events.InternalEvents
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketJoinRoomModel

internal interface PluginsInternalRoomJoinListener {
  fun onRoomJoined()
}

internal interface PluginsInternalRoomJoinListenerStore {
  fun addListener(listener: PluginsInternalRoomJoinListener)

  fun removeListener()
}

/**
 * Adapts InternalEvents onRoomJoined event to Plugins, removing the extra events which are not
 * related to Plugins feature like connectMedia, disconnectMedia.
 */
internal class PluginsInternalRoomJoinEventAdapter :
  PluginsInternalRoomJoinListenerStore, InternalEvents {
  private var listener: PluginsInternalRoomJoinListener? = null

  override fun addListener(listener: PluginsInternalRoomJoinListener) {
    this.listener = listener
  }

  override fun removeListener() {
    this.listener = null
  }

  override fun onRoomJoined(webSocketJoinRoomModel: WebSocketJoinRoomModel) {
    super.onRoomJoined(webSocketJoinRoomModel)
    listener?.onRoomJoined()
  }
}
