package io.dyte.core.feat

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.controllers.RecordingController
import io.dyte.core.events.PublicAPIEmitter
import io.dyte.core.listeners.DyteRecordingEventsListener
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

/**
 * Dyte recording
 *
 * @constructor Create empty Dyte recording
 * @property controllerContainer
 */
class DyteRecording
internal constructor(
  internal val recordingController: RecordingController,
  private val serialScope: CoroutineScope
) : PublicAPIEmitter<DyteRecordingEventsListener>() {
  val recordingState: DyteRecordingState
    get() = recordingController.getState()

  override val emitterSuperClass = recordingController

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["recordingState"] = recordingState
    return map
  }

  /** Starts recording of a given meeting */
  fun start() {
    serialScope.launch { recordingController.start() }
  }

  /** Stops recording of a given meeting */
  fun stop() {
    serialScope.launch { recordingController.stop() }
  }
}
