package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteWebinar internal constructor(private val controllerContainer: IControllerContainer) {
  private val serialScope = CoroutineScope(newSingleThreadContext("DyteWebinar"))
  val requestedParticipants = controllerContainer.stageController.requestedParticipants

  val viewers =
    controllerContainer.participantController.meetingRoomParticipants.joined.filter { it.flags.webinarHiddenParticipant }

  fun requestToJoin() {
    serialScope.launch {
      controllerContainer.stageController.joinStage()
    }
  }

  fun withdrawRequestToJoin() {
    serialScope.launch {
      controllerContainer.stageController.withdrawRequestToJoinStage()
    }
  }

  fun leaveStage() {
    serialScope.launch {
      controllerContainer.stageController.leaveStage()
    }
  }

  // TODO : add audioEnable, videoEnable in this api
  fun acceptRequestToPresent() {
    serialScope.launch {
      controllerContainer.stageController.acceptRequestToPresent()
    }
  }

  fun rejectRequestToPresent() {
    serialScope.launch {
      controllerContainer.stageController.rejectRequestToPresent()
    }
  }

  fun acceptRequest(id: String) {
    serialScope.launch {
      controllerContainer.stageController.acceptRequest(id)
    }
  }

  fun acceptAllRequest() {
    serialScope.launch {
      controllerContainer.stageController.acceptAllRequest()
    }
  }

  fun rejectRequest(id: String) {
    serialScope.launch {
      controllerContainer.stageController.rejectRequest(id)
    }
  }

  fun rejectAllRequest() {
    serialScope.launch {
      controllerContainer.stageController.rejectAllRequest()
    }
  }

  fun isPresenting(): Boolean {
    return controllerContainer.stageController.isPresenting()
  }

  fun canJoinStage(): Boolean {
    return controllerContainer.webinarController.canJoinStage()
  }
}