package io.dyte.core.controllers

import io.dyte.core.models.DyteMediaPermission.ALLOWED
import io.dyte.core.network.info.DyteDesignToken
import io.dyte.core.network.info.ParticipantInfo
import io.dyte.core.network.info.SelfPermissions

internal class PresetController(
  private val participantInfo: ParticipantInfo,
  controllerContainer: IControllerContainer
) :
  BaseController(controllerContainer), IPresetController {

  override val permissions: SelfPermissions
    get() = participantInfo.presetInfo.permissions

  override val designToken: DyteDesignToken
    get() = participantInfo.presetInfo.ui

  override fun canPublishVideo(): Boolean {
    return participantInfo.presetInfo.permissions.media.canPublishVideo || controllerContainer.stageController.isPresenting() || controllerContainer.stageController.stageStatus == StageStatus.ON_STAGE
  }

  override fun canPublishAudio(): Boolean {
    return participantInfo.presetInfo.permissions.media.audioPermission == ALLOWED || controllerContainer.stageController.isPresenting() || controllerContainer.stageController.stageStatus == StageStatus.ON_STAGE
  }

  override fun canCreatePoll(): Boolean {
    return participantInfo.presetInfo.permissions.polls.canCreate
  }

  override fun canViewPoll(): Boolean {
    return participantInfo.presetInfo.permissions.polls.canView
  }

  override fun canVoteOnPoll(): Boolean {
    return participantInfo.presetInfo.permissions.polls.canVote
  }

  override fun closePlugins(): Boolean {
    return participantInfo.presetInfo.permissions.plugins.canClose
  }

  override fun canStartPlugins(): Boolean {
    return participantInfo.presetInfo.permissions.plugins.canLaunch
  }

  override fun getMaxVideoCount(): Int {
    return participantInfo.presetInfo.gridInfo.maxParticipantsPerPage
  }

  override fun canRecord(): Boolean {
    return participantInfo.presetInfo.permissions.host.canTriggerRecording
  }

  override fun canSendChatText(): Boolean {
    return participantInfo.presetInfo.permissions.chat.canSendText
  }

  override fun canSendChatFile(): Boolean {
    return participantInfo.presetInfo.permissions.chat.canSendFiles
  }

  override fun canDoParticipantHostControls(): Boolean {
    return participantInfo.presetInfo.permissions.host.canMuteAudio
      || participantInfo.presetInfo.permissions.host.canMuteVideo
      || participantInfo.presetInfo.permissions.host.canKickParticipant
      || participantInfo.presetInfo.permissions.host.canPinParticipant
  }
}

interface IPresetController {
  val permissions: SelfPermissions
  val designToken: DyteDesignToken

  fun canPublishVideo(): Boolean
  fun canPublishAudio(): Boolean

  fun canCreatePoll(): Boolean
  fun canViewPoll(): Boolean
  fun canVoteOnPoll(): Boolean

  fun canSendChatText(): Boolean
  fun canSendChatFile(): Boolean

  fun closePlugins(): Boolean
  fun canStartPlugins(): Boolean

  fun getMaxVideoCount(): Int

  fun canRecord(): Boolean

  fun canDoParticipantHostControls(): Boolean
}