package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteWebinar internal constructor(private val controllerContainer: IControllerContainer) {
  private  val serialScope = CoroutineScope(newSingleThreadContext("DyteWebinar"))
  val requestedParticipants = controllerContainer.webinarController.requestedParticipants

  val viewers = controllerContainer.participantController.meetingRoomParticipants.joined.filter { it.flags.webinarHiddenParticipant }

  fun requestToJoin() {
    serialScope.launch {
      controllerContainer.webinarController.joinStage()
    }
  }

  fun withdrawRequestToJoin() {
    serialScope.launch {
      controllerContainer.webinarController.withdrawRequestToJoinStage()
    }
  }

  fun leaveStage() {
    serialScope.launch {
      controllerContainer.webinarController.leaveStage()
    }
  }

  // TODO : add audioEnable, videoEnable in this api
  fun acceptRequestToPresent() {
    serialScope.launch {
      controllerContainer.webinarController.acceptRequestToPresent()
    }
  }

  fun rejectRequestToPresent() {
    serialScope.launch {
      controllerContainer.webinarController.rejectRequestToPresent()
    }
  }

  fun acceptRequest(id: String) {
    serialScope.launch {
      controllerContainer.webinarController.acceptRequest(id)
    }
  }

  fun acceptAllRequest() {
    serialScope.launch {
      controllerContainer.webinarController.acceptAllRequest()
    }
  }

  fun rejectRequest(id: String) {
    serialScope.launch {
      controllerContainer.webinarController.rejectRequest(id)
    }
  }

  fun rejectAllRequest() {
    serialScope.launch {
      controllerContainer.webinarController.rejectAllRequest()
    }
  }

  fun isPresenting(): Boolean {
    return controllerContainer.webinarController.isPresenting()
  }

  fun canJoinStage(): Boolean {
    return controllerContainer.webinarController.canJoinStage()
  }
}