package io.dyte.core.utils

import io.dyte.core.models.DyteMeetingType

internal object DyteUtils {
  internal val DyteMeetingType.supportsAudioProduction: Boolean
    get() {
      return when (this) {
        DyteMeetingType.GROUP_CALL -> true
        DyteMeetingType.WEBINAR -> true
        DyteMeetingType.AUDIO_ROOM -> true
        DyteMeetingType.LIVESTREAM -> true
        DyteMeetingType.CHAT -> false
      }
    }

  internal val DyteMeetingType.supportsVideoProduction: Boolean
    get() {
      return when (this) {
        DyteMeetingType.GROUP_CALL -> true
        DyteMeetingType.WEBINAR -> true
        DyteMeetingType.AUDIO_ROOM -> false
        DyteMeetingType.LIVESTREAM -> true
        DyteMeetingType.CHAT -> false
      }
    }
}
