package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.models.VideoScaleType

/**
 * I dependency provider
 *
 * needs to be implemented by android & iOS separately.
 *
 * @constructor Create empty I dependency provider
 */
internal interface IDytePlatformUtilsProvider {
  val videoScaleType: VideoScaleType

  fun init(controllerContainer: IControllerContainer)

  fun getPlatformUtils(): IDytePlatformUtils

  fun getMediaUtils(): IDyteMediaUtils

  fun getControllerContainer(): IControllerContainer

  fun createWebView(): IDyteWebView

  fun getVideoUtils(): IDyteVideoUtils

  fun getPermissionUtils(): IDytePlatformPermissionUtils
}
