package io.dyte.core.featureflag

internal interface FeatureFlagService {

  /*
   * Fetches all the feature flags for mobile-core in context of the current user.
   * Context is determined mainly using a user's identifier and properties like their
   * organization, the meeting room-name, their Dyte SDK etc.
   * */
  suspend fun initializeWithUserContext(identifier: String, userAttributes: Map<String, Any>)

  fun isFeatureEnabled(featureName: String): Boolean

  fun getConfigValue(configName: String): String

  object UserAttributeKeys {
    const val ENTITY = "entity"
    const val ORGANIZATION_ID = "organization_id"
    const val ANONYMOUS_USER = "isAnonUser"
    const val ROOM_NAME = "roomName"
    const val CLIENT_ID = "clientId"
    const val SDK_VERSION = "sdkVersion"
    const val IS_MOBILE = "isMobile"
    const val OS_NAME = "osName"
    const val OS_VERSION_NAME = "osVersionName"
  }
}

/*
 * TODO(swapnil): Understand the usage from the web team and decide whether this can be converted to an enum.
 * */
internal object DyteFeatureFlagEntity {
  const val PARTICIPANT = "PARTICIPANT"
  const val PEER = "PEER"
  const val CLIENT = "CLIENT"
}

internal object DyteFeatureFlags {
  const val H264_SCREENSHARE = "h264_screenshare"
  const val QUICK_ZOOM = "quick_zoom"
  const val INTERNAL_CALL_STATS = "internal_call_stats"
  const val CFWS = "cfws"
  const val LOGROCKET = "logrocket"
  const val SIMULCAST = "simulcast"
  const val CHAT_SOCKET_SERVER = "chat_socket_server"
  const val POLL_SOCKET_SERVER = "poll_socket_server"
  const val PLUGIN_SOCKET_SERVER = "plugin_socket_server"
  const val NR_OTEL_WEB = "nr_otel_web"
  const val CONNECTED_MEETINGS = "connected_meetings"
  const val FEAT_SPOTLIGHT = "feat_spotlight"
  const val ICE_RESTART_ON_FAILED_STATE = "ice_restart_on_failed_state"
  const val ENABLE_ICE_STATE_LOGGING = "enable_ice_state_logging"
  const val REMOVE_TOGGLE_AUDIO = "remove_toggle_audio"
  const val REMOVE_OPERATIONAL_MIC = "web_core_remove_operational_mic"
  const val SKIP_OTEL_TRACES = "skip_otel_traces"
  const val CALLSTATS_INGESTION_LAYER = "callstats_ingestion_layer"
  const val USE_USERIDS_IN_CHAT = "use_userids_in_chat"
  const val V1_PLUGINS = "v1_plugins"
  const val ENABLE_HIVE_TRANSPORT_RECONNECTION_ON_ICE_FAILED =
    "enable_hive_transport_reconnection_on_ice_failed"
  const val SOFTWARE_DECODER_OVERRIDE = "mobile_force_software_decoder"
  const val SOFTWARE_ENCODER_OVERRIDE = "mobile_force_software_encoder"
}
